<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-09-10 14:26
 */
interface TypeClientDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return type
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param type primary key
 	 */
	public function delete($typeId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param type branch
 	 */
	public function insert($type);
	
	/**
 	 * Update record in table
 	 *
 	 * @param type branch
 	 */
	public function update($type);

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByTypeName($value);

	public function queryByTypeDate($value);


	public function deleteByTypeName($value);

	public function deleteByTypeDate($value);


}
?>